close all
clearvars
clc
%% Open variables for the year 2020
% OPEN
data0=load('OPEN_2020.mat');
Open0=data0.OPEN_2020;
% MOSE
data0=load('MOSE_2020.mat');
Mose0=data0.MOSE_2020;
% ATHOS
data0= load('ATHOS_2020.mat');
Athos0=data0.ATHOS_2020;
%% PLOT FIGURES for the year 2020
%OPEN
numStations = size(Open0, 2);
numObservations = size(Open0, 1);
x_min=0;
x_max=max(Open0);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Open0(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end

figure()
hold on
plot(x_out(:,1),mean(f_out'),'b','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--b','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--b','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Mose0, 2);
numObservations = size(Mose0, 1);
x_min=0;
x_max=max(Mose0);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Mose0(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'r','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--r','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--r','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Athos0, 2);
numObservations = size(Athos0, 1);
x_min=0;
x_max=max(Athos0);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Athos0(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'g','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--g','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--g','LineWidth',1,'HandleVisibility', 'off')
ylim([0 1])
ylabel('CDF')
xlim([0 2])
xlabel('Water levels (m above local datum)')
legend('WL OPEN', 'conf. interval 95% OPEN', 'WL MOSE', 'conf. interval 95% MOSE','WL ATHOS', 'conf. interval 95% ATHOS')
title('2020')
%% Open variables for the year 2021
% OPEN
data1=load('OPEN_2021.mat');
Open1=data1.OPEN_2021;
% MOSE
data1=load('MOSE_2021.mat');
Mose1=data1.MOSE_2021;
% ATHOS
data1= load('ATHOS_2021.mat');
Athos1=data1.ATHOS_2021;
%% PLOT FIGURES for the year 2021
%OPEN
numStations = size(Open1, 2);
numObservations = size(Open1, 1);
x_min=0;
x_max=max(Open1);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Open1(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end

figure()
hold on
plot(x_out(:,1),mean(f_out'),'b','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--b','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--b','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Mose1, 2);
numObservations = size(Mose1, 1);
x_min=0;
x_max=max(Mose1);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Mose1(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'r','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--r','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--r','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Athos1, 2);
numObservations = size(Athos1, 1);
x_min=0;
x_max=max(Athos1);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Athos1(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'g','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--g','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--g','LineWidth',1,'HandleVisibility', 'off')
ylim([0 1])
ylabel('CDF')
xlim([0 2])
xlabel('Water levels (m above local datum)')
legend('WL OPEN', 'conf. interval 95% OPEN', 'WL MOSE', 'conf. interval 95% MOSE','WL ATHOS', 'conf. interval 95% ATHOS')
title('2021')

%% Open variables for the year 2022
% OPEN
data2=load('OPEN_2022.mat');
Open2=data2.OPEN_2022;
% MOSE
data2=load('MOSE_2022.mat');
Mose2=data2.MOSE_2022;
% ATHOS
data2= load('ATHOS_2022.mat');
Athos2=data2.ATHOS_2022;

%% PLOT FIGURES for the year 2022
%OPEN
numStations = size(Open2, 2);
numObservations = size(Open2, 1);
x_min=0;
x_max=max(Open2);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Open2(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end

figure()
hold on
plot(x_out(:,1),mean(f_out'),'b','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--b','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--b','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Mose2, 2);
numObservations = size(Mose2, 1);
x_min=0;
x_max=max(Mose2);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Mose2(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'r','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--r','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--r','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Athos2, 2);
numObservations = size(Athos2, 1);
x_min=0;
x_max=max(Athos2);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Athos2(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'g','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--g','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--g','LineWidth',1,'HandleVisibility', 'off')
ylim([0 1])
ylabel('CDF')
xlim([0 2])
xlabel('Water levels (m above local datum)')
legend('WL OPEN', 'conf. interval 95% OPEN', 'WL MOSE', 'conf. interval 95% MOSE','WL ATHOS', 'conf. interval 95% ATHOS')
title('2022')
%% Open variables for the year 2023
% OPEN
data3=load('OPEN_2023.mat');
Open3=data3.OPEN_2023;
% MOSE
data3=load('MOSE_2023.mat');
Mose3=data3.MOSE_2023;
% ATHOS
data3= load('ATHOS_2023.mat');
Athos3=data3.ATHOS_2023;

%% PLOT FIGURES for the year 2022
%OPEN
numStations = size(Open3, 2);
numObservations = size(Open3, 1);
x_min=0;
x_max=max(Open3);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Open3(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end

figure()
hold on
plot(x_out(:,1),mean(f_out'),'b','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--b','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--b','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Mose3, 2);
numObservations = size(Mose3, 1);
x_min=0;
x_max=max(Mose3);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Mose3(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'r','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--r','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--r','LineWidth',1,'HandleVisibility', 'off')

%MOSE
numStations = size(Athos3, 2);
numObservations = size(Athos3, 1);
x_min=0;
x_max=max(Athos3);
x_out=[];
f_out=[];
cdfMatrix = zeros(numObservations, numStations);
for i = 1:numStations
    i;
    [x,f] = customEcdf(Athos3(:,i),0.01,x_min,x_max);
    x_out(:,i)=x';
    f_out(:,i)=f';
end
plot(x_out(:,1),mean(f_out'),'g','LineWidth',2)
plot(x_out(:,1),mean(f_out')+std(f_out')./2,'--g','LineWidth',1)
plot(x_out(:,1),mean(f_out')-std(f_out')./2,'--g','LineWidth',1,'HandleVisibility', 'off')
ylim([0 1])
ylabel('CDF')
xlim([0 2])
xlabel('Water levels (m above local datum)')
legend('WL OPEN', 'conf. interval 95% OPEN', 'WL MOSE', 'conf. interval 95% MOSE','WL ATHOS', 'conf. interval 95% ATHOS')
title('2023')
%% 


function [binCenters, ecdfValues] = customEcdf(data, binWidth,minData,maxData)
    % Check if the data is a non-empty numeric vector
    if isempty(data) || ~isnumeric(data)
        error('Input data must be a non-empty numeric vector.');
    end
    
    % Check if the binWidth is a positive numeric scalar
    if isempty(binWidth) || ~isnumeric(binWidth) || binWidth <= 0
        error('Bin width must be a positive numeric scalar.');
    end
    
    % Create bin edges based on the specified bin width
    binEdges = minData:binWidth:maxData;
    
    % Calculate bin centers
    binCenters = binEdges(1:end-1) + binWidth / 2;
    
    % Initialize the ECDF values
    ecdfValues = zeros(1, length(binCenters));
    
    % Compute the ECDF values
    for i = 1:length(binCenters)
        ecdfValues(i) = sum(data <= binEdges(i + 1)) / length(data);
    end
end